/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.libs.com.moandjiezana.toml;

import com.github.quiltservertools.libs.com.moandjiezana.toml.ArrayValueWriter;
import com.github.quiltservertools.libs.com.moandjiezana.toml.NewMapValueWriter;
import com.github.quiltservertools.libs.com.moandjiezana.toml.Toml4jValueWriters;
import com.github.quiltservertools.libs.com.moandjiezana.toml.ValueWriter;
import com.github.quiltservertools.libs.com.moandjiezana.toml.WriterContext;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/github/quiltservertools/libs/com/moandjiezana/toml/NewArrayValueWriter;", "Lcom/github/quiltservertools/libs/com/moandjiezana/toml/ArrayValueWriter;", "", "value", "", "canWrite", "(Ljava/lang/Object;)Z", "o", "Lcom/github/quiltservertools/libs/com/moandjiezana/toml/WriterContext;", "context", "", "write", "(Ljava/lang/Object;Lcom/github/quiltservertools/libs/com/moandjiezana/toml/WriterContext;)V", "<init>", "()V", "konf-toml"})
public final class NewArrayValueWriter
extends ArrayValueWriter {
    @NotNull
    public static final NewArrayValueWriter INSTANCE;

    @Override
    public boolean canWrite(@Nullable Object value2) {
        return ArrayValueWriter.isArrayish(value2);
    }

    @Override
    public void write(@NotNull Object o, @NotNull WriterContext context) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Collection<?> values2 = this.normalize(o);
        context.write('[');
        context.writeArrayDelimiterPadding();
        boolean first = true;
        ValueWriter firstWriter = null;
        for (Object value2 : values2) {
            ValueWriter writer;
            if (first) {
                Object obj = value2;
                Intrinsics.checkNotNull(obj);
                firstWriter = Toml4jValueWriters.INSTANCE.findWriterFor(obj);
                first = false;
            } else {
                Object obj = value2;
                Intrinsics.checkNotNull(obj);
                writer = Toml4jValueWriters.INSTANCE.findWriterFor(obj);
                if (writer != firstWriter) {
                    throw (Throwable)new IllegalStateException(context.getContextPath() + ": cannot write a heterogeneous array; first element was of type " + firstWriter + " but found " + writer);
                }
                context.write(", ");
            }
            writer = Toml4jValueWriters.INSTANCE.findWriterFor(value2);
            boolean isNestedOldValue = NewMapValueWriter.INSTANCE.isNested();
            if (Intrinsics.areEqual((Object)writer, (Object)NewMapValueWriter.INSTANCE)) {
                NewMapValueWriter.INSTANCE.setNested(true);
            }
            writer.write(value2, context);
            if (!Intrinsics.areEqual((Object)writer, (Object)NewMapValueWriter.INSTANCE)) continue;
            NewMapValueWriter.INSTANCE.setNested(isNestedOldValue);
        }
        context.writeArrayDelimiterPadding();
        context.write(']');
    }

    private NewArrayValueWriter() {
    }

    static {
        NewArrayValueWriter newArrayValueWriter;
        INSTANCE = newArrayValueWriter = new NewArrayValueWriter();
    }
}

